/*******************************************************
Filename		:  FA_BLOB.sql
Release 		:  2.0.1
SIR			:  1558
Description		:  Create Data Warehouse BLOB table with everything from TSMBLOB table and the blob type and title from
			   the appropriate related tables 
Author		:  Joe Wilson
Date			:  10/28/2003
Comments		:  10/30/2003 Added Activity Blob update - WN
			:  
**********************************************************/
spool fa_blob.log
connect storetw/storetw@storet.sdc

--create consolidated blob table
drop table fa_blob;

create table fa_blob 
tablespace storetdata
storage (initial 100M next 50M minextents 2 maxextents 200) 
as 
select * from storet1.tsmblob;

alter table fa_blob add blob_type char(3);
alter table fa_blob add blob_title varchar2(60);

update fa_blob fa set (fa.blob_type,fa.blob_title) = (
 	select blob_type,blob_title from storet1.tsrcitn citn
  		where fa.tsrcitn_is_number = citn.tsrcitn_is_number
  		and fa.tsrcitn_org_id = citn.tsrcitn_org_id )
where fa.tsrcitn_is_number is not null;

update fa_blob fa set (fa.blob_type,fa.blob_title) = (
	select blob_type,blob_title from storet1.tsrstvst stvst
		where fa.tsrstvst_is_number = stvst.tsrstvst_is_number
		and fa.tsrstvst_org_id = stvst.tsrstvst_org_id )
where fa.tsrstvst_is_number is not null;

update fa_blob fa set (fa.blob_type,fa.blob_title) = (
	select blob_type,blob_title from storet1.tsropprd opprd
		where fa.tsropprd_is_number = opprd.tsropprd_is_number
		and fa.tsropprd_org_id = opprd.tsropprd_org_id )
where fa.tsropprd_is_number is not null;

update fa_blob fa set (fa.blob_type,fa.blob_title) = (
	select blob_type,blob_title from storet1.tsrfdact fdact
		where fa.tsrfdact_is_number = fdact.tsrfdact_is_number
		and fa.tsrfdact_org_id = fdact.tsrfdact_org_id )
where fa.tsrfdact_is_number is not null;

update fa_blob fa set (fa.blob_type,fa.blob_title) = (
	select blob_type,blob_title from storet1.tsmproj proj
		where fa.tsmproj_is_number = proj.tsmproj_is_number
		and fa.tsmproj_org_id = proj.tsmproj_org_id )
where fa.tsmproj_is_number is not null;

update fa_blob fa set (fa.blob_type,fa.blob_title) = (
	select blob_type,blob_title from storet1.tsrrsult rsult
		where fa.tsrrsult_is_number = rsult.tsrrsult_is_number
		and fa.tsrrsult_org_id = rsult.tsrrsult_org_id )
where fa.tsrrsult_is_number is not null;

update fa_blob fa set (fa.blob_type,fa.blob_title) = (
	select blob_type,blob_title from storet1.tsmstatn statn
		where fa.tsmstatn_is_number = statn.tsmstatn_is_number
		and fa.tsmstatn_org_id = statn.tsmstatn_org_id )
where fa.tsmstatn_is_number is not null;

--alter table fa_blob add blob_id varchar2(21);
alter table fa_blob add organization_is_number number(12);


update fa_blob fa set (fa.organization_is_number) = (
	select org.organization_is_number
		from di_org org
		where fa.tsmblob_org_id = org.organization_id);

commit;


--add blob id to the fact tables:

alter table fa_station add blob_id varchar2(25);
update fa_station st set blob_id = (
	select organization_is_number||'-'||TSMBLOB_IS_NUMBER
	from fa_blob fa
	where tsmstatn_is_number = st.station_is_number
	and tsmstatn_org_id = st.organization_id)
where st.blob_title is not null;

--add blob_id to regular result
update fa_regular_result re set (blob_id) = (
	select organization_is_number||'-'||TSMBLOB_IS_NUMBER
	from fa_blob fa
	where tsrrsult_is_number = re.result_is_number
	and tsrrsult_org_id = re.organization_id)
where blob_title is not null;
-- activity blob id for regular result
update fa_regular_result re set (act_blob_id) = (
	select organization_is_number||'-'||TSMBLOB_IS_NUMBER
	from fa_blob fa
	where TSRFDACT_IS_NUMBER = re.ACTIVITY_IS_NUMBER
	and   TSRFDACT_org_id = re.organization_id)
where act_blob_title is not null;

--add blob_id to biological result
update fa_biological_result re set (blob_id) = (
	select organization_is_number||'-'||TSMBLOB_IS_NUMBER
	from fa_blob fa
	where tsrrsult_is_number = re.result_is_number
	and tsrrsult_org_id = re.organization_id)
where blob_title is not null;
-- activity blob id for biological result
update fa_biological_result re set (act_blob_id) = (
	select organization_is_number||'-'||TSMBLOB_IS_NUMBER
	from fa_blob fa
	where TSRFDACT_IS_NUMBER = re.ACTIVITY_IS_NUMBER
	and   TSRFDACT_org_id = re.organization_id)
where act_blob_title is not null;

--add blob_id to habitat result
update fa_habitat_result re set (blob_id) = (
	select organization_is_number||'-'||TSMBLOB_IS_NUMBER
	from fa_blob fa
	where tsrrsult_is_number = re.result_is_number
	and tsrrsult_org_id = re.organization_id)
where blob_title is not null;
-- activity blob id for habitat result
update fa_habitat_result re set (act_blob_id) = (
	select organization_is_number||'-'||TSMBLOB_IS_NUMBER
	from fa_blob fa
	where TSRFDACT_IS_NUMBER = re.ACTIVITY_IS_NUMBER
	and   TSRFDACT_org_id = re.organization_id)
where act_blob_title is not null;

commit;

spool off